# 添加通讯录好友
## 介绍
添加通讯录好友是社交通讯类应用中的典型场景之一。

本示例基于[@ohos.contact](https://developer.huawei.com/consumer/cn/doc/harmonyos-references/js-apis-contact)实现读取通讯录、选择手机联系人并添加为好友的功能。
## 效果预览
<img src="screenshots/friends.gif" width="200">

## 约束与限制
* 本示例支持API Version 20 Release及以上版本。
* 本示例支持HarmonyOS 6.0.0 Release SDK及以上版本。
* 本示例需要使用DevEco Studio 6.0.0 Release及以上版本进行编译运行。
## 使用说明
1. 点击右上角的加号，出现“添加好友”的按钮，点击跳转到添加好友页面。
2. 点击“手机联系人”，出现选择联系人的弹窗。
## 实现思路
1. 调用[contact.selectContacts](https://developer.huawei.com/consumer/cn/doc/harmonyos-references/js-apis-contact#contactselectcontacts10-1)接口，打开选择联系人界面，选择通讯录中要添加为好友的联系人。
   ```
   // 选择联系人
   selectContacts() {
     // 调用通讯录选择组件，让用户选择需要传入APP的通讯录联系人
     let promise = contact.selectContacts(contactSelectionOptions);
     promise.then((data) => {
     })
   }  
   ```
2. 联系人选择完成后，跳转至添加好友页面，展示可添加为好友的联系人列表。
    ```
    // 联系人列表
    List() {
      ForEach(this.friendsList, (item: FriendsItem, index: number) => {});
    }
    ```
## 工程目录
```
├──entry/src/main/ets                           // 代码区
│  ├──entryability
│  │  └──EntryAbility.ets       
│  ├──model
│  │  ├──ContactData.ets                        // 通讯录数据
│  │  ├──LetterListData.ets                     // 字母列表数据
│  │  └──ListModel.ets                          // 列表结构
│  └──pages
│     ├──ContactsFriendsPage.ets                // 添加好友页面
│     └──MainPage.ets                           // 主页面
└──entry/src/main/resources                     // 应用资源目录
```
## 模块依赖
依赖三方库[@ohos/pinyin4js](https://ohpm.openharmony.cn/#/cn/detail/@ohos%2Fpinyin4js)实现联系人按字母排序功能。
## 参考文档
[@ohos.contact（联系人）](https://developer.huawei.com/consumer/cn/doc/harmonyos-references/js-apis-contact)